#{{uc_id}}
{
  direction:{{direction}};
}
#{{uc_id}} *
{
  box-sizing:border-box;
}
#{{uc_id}} .ue_timeline_item
{
  display:flex;
  flex-direction:row-reverse;
}

#{{uc_id}} .ue_timeline_item_icon
{
  display:flex;
  flex-direction:column;
  align-items:center;
}

#{{uc_id}} .ue_timeline_item_icon_line
{
  flex-grow:1;
}

#{{uc_id}} .ue_timeline_item_icon_line_offset
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_timeline_item_icon_holder
{
  display:flex;
  justify-content:center;
  align-items:center;
  line-height:1em;
  flex-direction:column;
  transition: all 0.4s ease-in-out;
}

#{{uc_id}} .ue_timeline_item_icon_holder svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue_timeline_item_content
{
  flex:1;
  flex-shrink:0;
  flex-direction:row-reverse;
}

#{{uc_id}} .ue_timeline_item_spacer
{
  flex:1;
  flex-shrink:0;
}

#{{uc_id}} .ue_timeline_item_content_main
{
  flex-grow:1;
  word-break: break-word;
  transition: all .3s;
}




#{{uc_id}} .ue_timeline_item_content
{
  display:flex;
}


#{{uc_id}} .ue_timeline_item_pointer_spacer
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_timeline_item_icon
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_timeline_item_pointer
{
  
  flex-grow:0;
  flex-shrink:0;
  margin-top:0px;
  position:relative;
}



#{{uc_id}} .ue_timeline_item .ue_timeline_item_content .ue_timeline_item_pointer .ue_timeline_item_pointer_inside
{
  position:relative;
  clip-path: polygon(0 50%, 100% 0, 100% 100%);
  transition: all .3s;
}

{% if hide_last_item_line == "true" %}
#{{uc_id}} .ue_timeline_item:last-child .ue_timeline_item_icon_line
{
  display:none;
}
{% endif %}	

#{{uc_id}} .ue_timeline_item:last-child .ue_timeline_item_content
{
  margin-bottom:0px;
}


#{{uc_id}} .ue_timeline_item_spacer
  {
    display:none;
  }


{% if alternating == "true" %}
	#{{uc_id}} .ue_timeline_item:nth-child(odd)
    {
      flex-direction:row;
    }

    #{{uc_id}} .ue_timeline_item:nth-child(odd) .ue_timeline_item_content
    {
     flex-direction:row;
    } 


	#{{uc_id}} .ue_timeline_item_spacer
  {
    display:block;
  }


#{{uc_id}} .ue_timeline_item:nth-child(odd) .ue_timeline_item_content .ue_timeline_item_pointer .ue_timeline_item_pointer_inside
{ 
 clip-path: polygon(100% 50%, 0 0, 0 100%);

}



	
{% endif %}	


#{{uc_id}} .ue_timeline_item_button{
	display: flex;
  	align-items: center;
}

#{{uc_id}} .ue_timeline_item_link{
	cursor: pointer;
  	transition: all .3s;
}


@media only screen and (max-width: {{responsive_breakpoint}}px) {
  #{{uc_id}} .ue_timeline_item
{
  flex-direction:row-reverse !important;
}

#{{uc_id}} .ue_timeline_item .ue_timeline_item_content
{
 flex-direction:row-reverse !important;
}
  
  #{{uc_id}} .ue_timeline_item_spacer
  {
    display:none;
  }
  
  #{{uc_id}} .ue_timeline_item .ue_timeline_item_content .ue_timeline_item_pointer .ue_timeline_item_pointer_inside
  { 
   clip-path: polygon(0 50%, 100% 0, 100% 100%) !important;

  }
  
}


{% if direction == "rtl" %}
   #{{uc_id}} .ue_timeline_item .ue_timeline_item_content .ue_timeline_item_pointer .ue_timeline_item_pointer_inside
   {
     transform: scaleX(-1);
   }
{% endif %}

.ue_timeline_item_title
{
  font-size:21px;
}

.ue_text_one, .ue_text_two, .ue_text_three
{
  font-size:14px;
  line-height:1.1em;
}

.ue_timeline_item_icon_line_mask, .ue_timeline_item_icon_line_offset_mask {
  width: 100%;
  height: 0%;
  max-height: 100%;
  will-change: height;
}
#{{uc_id}} .ue_timeline_item_image
{
object-fit: cover;
}

#{{uc_id}} .ue_timeline_item_content_inside
{
  position:relative;
}


#{{uc_id}} .ue_timeline_item_content_main
{
  position:relative;
  overflow:hidden;
}


{% if force_bg == "true" %}
#{{uc_id}} .ue_timeline_item_image
{
  position:absolute;
  top:0px;
  right:0px;
  height:100%;
  width:100%;
  bottom:0px;
  left:0px;
  border-radius:0;
  border:none;
  
}
{% endif %}